/*
 *  CNC: Concurrent Number Cruncher
 *  Copyright (C) 2008 GOCAD/ASGA, INRIA/ALICE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you modify this software, you should include a notice giving the
 *  name of the person performing the modification, the date of modification,
 *  and the reason for such modification.
 *
 *  Contact: Luc Buatois
 *
 *     buatois@gocad.org
 *
 *     ASGA-INPL Bt. G
 *     Rue du Doyen Marcel Roubault - BP 40
 *     54501 VANDOEUVRE LES NANCY
 *     FRANCE
 *
 *  Note that the GNU General Public License does not permit incorporating
 *  the Software into proprietary programs. 
 */

#include "../include/cnc_gpu_solver.h"
#include "../include/cnc_example_loader.h"


int _tmain(int argc, _TCHAR* argv[])
{

	CNCSparseMatrix A ( 1 ) ;
	floatArray b ( 1 ) ;

	unsigned int max_iter ;
	double epsilon ;
	std::string file ;

	if ( argc == 4 ) {
		max_iter = atoi ( argv[1] ) ;
		epsilon  = atof ( argv[2] ) ;
		file = argv[3] ;
	}
	else {
		max_iter = 2000  ;
		epsilon  = 0.001 ;
		file = "../examples/example_1.dat" ;

		printf ( "Wrong or no params provided !!!\n\nUsage : CG-GPU.exe max_iter epsilon file\n" ) ;
		printf ( "     max_iter = #max of iterations of the Conjugate Gradient solver\n" ) ;
		printf ( "     epsilon = required precision for the solution\n" ) ;
		printf ( "     file = filename containing a linear system (see examples dir)\n\n" ) ;
		printf ( "Trying with default values: max_iter=%d, epsilon=%f, file=%s\n", max_iter, epsilon, file.c_str() ) ;
	}

	if ( !ExampleLoader::load_example(file, A, b) ) {
		printf ( "Press enter to exit\n" ) ;
		getchar () ;
		return -1 ;
	}
		
	floatArray x_1 ( b.size() ) ;
	floatArray x_2 ( b.size() ) ;
	floatArray x_4 ( b.size() ) ;
	x_1.set_all ( 0.0f ) ;
	x_2.set_all ( 0.0f ) ;
	x_4.set_all ( 0.0f ) ;

	bool ok_1 = false ;
	bool ok_2 = false ;
	bool ok_4 = false ;

	ok_1 = CNCGPUSolver::solve_cg ( A, b, x_1, max_iter, epsilon, 1 ) ;
	ok_2 = CNCGPUSolver::solve_cg ( A, b, x_2, max_iter, epsilon, 2 ) ;
	ok_4 = CNCGPUSolver::solve_cg ( A, b, x_4, max_iter, epsilon, 4 ) ;

	CNC_SIMPLE_ASSERT ( ok_1, "CG GPU Solver did not work properly, see above for details" ) ;
	CNC_SIMPLE_ASSERT ( ok_2, "CG GPU Solver did not work properly, see above for details" ) ;
	CNC_SIMPLE_ASSERT ( ok_4, "CG GPU Solver did not work properly, see above for details" ) ;
	printf ( "------------------------------------------------------------\n" ) ;

	printf ( "Press enter to exit\n" ) ;
	getchar () ;

	return 0;
}
