#   This file is part of Cupydon.
#
#    Cupydon  is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Cupydon is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Cupydon.  If not, see <http://www.gnu.org/licenses/>
#
#    
#    Copyright(c):    ASGA, Gocad Consortium 2009-2013
#


# simple exemple 

from dtwlib import InFile, R2DTW, OutRes

import sys

# input file name
in_file_name = 'test3.txt'

#reference file name
ref_file_name = 'stdref.txt'

#output file name
out_file_name = 'simple_result'

#max number of path tested
max_path = 10

#number of result (must be <= max_path)
nbr_res = 5

#engine used
engine = R2DTW


#read ref file
ref_file =  InFile(ref_file_name)
if not ref_file.ok() :
    print 'Ref File Error:', ref_file.error()
    sys.exit(1)

#read input file
in_file =  InFile(in_file_name)
if not in_file.ok() :
    print 'Input File Error:', in_file.error()
    sys.exit(1)


#run engine
engine.max_path =    max_path
res = engine(ref_file.todtw(), in_file.todtw())

#get nbr_res first results
results = res.result[:nbr_res]


#write results 
out_res = OutRes( ref_file, in_file, results)

if not out_res.all_write_result(out_file_name) :
    print 'Result Error:', out_res.error()
    sys.exit(1)
print "Ok;"
