#   This file is part of Cupydon.
#
#    Cupydon  is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Cupydon is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Cupydon.  If not, see <http://www.gnu.org/licenses/>
#
#    
#    Copyright(c):    ASGA, Gocad Consortium 2009-2013
#

from PyQt4 import QtCore, QtGui
import sys, os
Qt = QtCore.Qt
#SLOT=Qt.SLOT



class OptEditItem(object):
    def __init__(self, oe,name, value,  **pp):
        self.name = name
        self.optedit = oe
        self.value = value
        oe._items.append(self)
        self.init(**pp)
        self.set(value)
        
        
    def set(self, value):
        self.value = value
        self.setval()
    
    def get(self):
        return self.value
        
    def check(self):
        return True
        
    def init(self): 
        pass
    
    
    def error(self, s):
        QtGui.QMessageBox.critical(self.optedit,"Error" , s)
        
        
    #setval : value->widget
    #getval : widget->value

class OELineEdit(OptEditItem):
    "OptEditItem with QLineEdit"
    
    def le_init(self,  tooltip = None):
        w = self.widget = QtGui.QLineEdit(self.optedit)
        self.optedit._addwidget(self.name, w)
        self.validator = None
        if tooltip : w.setToolTip(tooltip)
    
    def setval(self):
        self.widget.setText(self.val2str(self.value))
        
    def getval(self):
        try : self.value = self.str2val(unicode(self.widget.text()))
        except Exception, v :
            self.error(u'GetValError %s : %s'%(repr(self), unicode(v)))
        
    def val2str(self, s): return unicode(s)
    
    def error(self, s= "Bad value"):
        OptEditItem.error(self, s)
        self.widget.selectAll()
        self.widget.setFocus()
    
    def check(self):
        if self.validator :
            a, b =  self.validator.validate(self.widget.text(), 0)
            if a != QtGui.QValidator.Acceptable :
                self.error()
                return False
            return True
            
        pass
    
class OEInt(OELineEdit):
    def init(self, min = None, max = None, tooltip = None):
        self.le_init(tooltip)
        v = self.validator = QtGui.QIntValidator(self.widget)
        self.min = min
        self.max = max
        if self.min is not None  : v.setBottom(self.min)
        if self.max is not None  : v.setTop(self.max)
        self.widget.setValidator(v)
        
    def str2val(self, s): return int(s)
        
        
class OEFloat(OELineEdit):
    def init(self, min = None, max = None, tooltip = None):
        self.le_init(tooltip)
        v = self.validator = QtGui.QDoubleValidator(self.widget)
        self.min = min
        self.max = max
        if self.min is not None  : v.setBottom(self.min)
        if self.max is not None  : v.setTop(self.max)
        self.widget.setValidator(v)
        
    def str2val(self, s): return float(s)
    
        


class OptEdit(QtGui.QDialog):
    
    def __init__(self, main=None, caption='OptEdit'):
        super(OptEdit, self).__init__( main)
        self.setWindowTitle(caption)
        self.setSizeGripEnabled(True)

        self._tlo = QtGui.QFormLayout(self)
        self._tlopos = 0
        
        BB=QtGui.QDialogButtonBox
        w = BB(self)
        b = w.addButton(BB.Ok) 
        b.clicked.connect(self.do_ok)
        b.setDefault(True)
        w.addButton(BB.Cancel) .clicked.connect(self.reject)
        w.addButton(BB.Reset) .clicked.connect(self.do_reset)
        self._tlo.addRow(w)
        self._items = []
        
        
    def do_reset(self):
        for i in self._items :
            i.setval()
            
    def do_check(self):
        for i in self._items :
            if not i.check() : return False
        for i in self._items :
            i.getval()
        return True
        
    def do_ok(self): 
        if self.do_check() :
            self.accept()
        
    def _addwidget(self, *p, **pp):
        self._tlo.insertRow(self._tlopos, *p, **pp)
        self._tlopos+=1
    
    
    def run(self):
        self.do_reset()
        return  self.exec_() == self.Accepted
    
    def test(self):
        print self.do_check()
        print 'Ok'


def test():
    app = QtGui.QApplication(sys.argv)
    w = QtGui.QMainWindow()
    opt = OptEdit (  w)
    
    OEInt(opt, 'Value1', 0, tooltip = "test tooltip")
    OEInt(opt, 'Value2 ffff', 50, min=100, max=3000)
    
    
    w.show()
    print opt.run()
    print opt.run()
    print 'Ok;'

if __name__=='__main__' : test()    


