#!/usr/bin/env python

#   This file is part of Cupydon.
#
#    Cupydon  is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Cupydon is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Cupydon.  If not, see <http://www.gnu.org/licenses/>
#
#    
#    Copyright(c):    ASGA, Gocad Consortium 2009-2013
#



from dtwlib import *
import sys, os

prog_name = 'Cupidon'
prog_version = '0.99'
prog_date = '07/04/2011'


_basedir = os.path.normpath(os.path.dirname(sys.argv[0]))

#print _basedir

class Run:
    infile = None
    infileopt = ""
    engine = R2DTW
    
    reffile = os.path.join(_basedir, 'stdref.txt')
    reffileopt= ""
    
    
    outfile = 'res'            
    outext = '.txt'
    outopt = ''
    
    nbrres = 5
    maxpath = None #default (max(5,2*self.nbrres)
       
    showgraph = False 
    #engine = RDTW3
    #engine = SDTW
    
    
    def __init__(self, *p, **pp):
        self.init(*p, **pp)

    def init(self, infile= None, infileopt = ""):
        self._error = None
        self.infile = infile
        self.infileopt = infileopt
        
    def ok(self): return not self._error
    def error(self): return self._error
    
    def check(self):
        self._error = None
        if not self.infile :
            self._error = "No Input File"
            return False
            
        if self.nbrres < 1 :
            self._error = "Need a least one result"
            return False
            
        if self.maxpath is None :
            self.maxpath = max(10, self.nbrres *2)
        elif self.maxpath < self.nbrres :
           self.maxpath = self.nbrres 
        
        return True
    
    
    def run(self):
        if not self.check() : return False
        
        #read in file
        infile = InFile(self.infile, self.infileopt)
        
        
        if not infile.ok() :
            self._error = infile.error()
            return False
            
        #ref
        ref = InFile(self.reffile, self.reffileopt)
        if not ref.ok() :
            self._error = ref.error()
            return False

        #init_engine
        class rengine (self.engine) :
            pass
           
        rengine.max_path = self.maxpath
        
        
        #run engine
        
        res = rengine(ref.todtw(), infile.todtw())
        
        results = res.result[:self.nbrres]
        
        #res.dump_result()
        if True :
            for n, rr  in enumerate(results ): 
                c, r = rr
                print "#%i"%(n+1),c,ref.desc[r[0][0]],'-',ref.desc[r[-1][1]]
                
                
        # out all res 
        if True :
            f = open(self.outfile+'.all'+self.outext, "wt") 
            for n, rr  in enumerate(results ): 
                c, r = rr
                f.write('%02i\t%5f\t%s - %s \n'%(
                    n, 
                    c, 
                    ref.desc[r[0][0]], 
                    ref.desc[r[-1][1]], 
                    
                ))
            f.close()
        # out sep res
        if  True :
            for n, rr  in enumerate(results ): 
                c, r = rr
                f = open("%s.%03i%s"%(self.outfile,n, self.outext ), 'wt')
                if True :
                    f.write('#infile: %s\n'%self.infile)
                    f.write('#reffile: %s\n'%self.reffile)
                    f.write('#result %i, cost=%5f, range:%s-%s\n\n'%(
                            n, c,  ref.desc[r[0][0]],  ref.desc[r[-1][1]]))
                            
                if True :
                    f.write('Date  \tProf\n')
                if True : #by in items/prof
                    for ni, start_end in enumerate(r) :
                        start, end = start_end
                        oline = []
                        oline.append('%f'%ref.prof[start])
                        oline.append('%f'%infile.prof[ni])
                        if start == end :
                            oline.append(ref.desc[start])
                        else :
                            oline.append(ref.desc[start]+' to '+ref.desc[end])
                        oline.append(infile.desc[ni])
                        
                        f.write('\t'.join(oline)+'\n')
                    oline.append('%f'%ref.prof[r[-1][1]])
                    oline.append('%f'%infile.prof[-1])
                    
                f.close()
                        
                
            
        
                
        
                
        #===
        if self.showgraph :
            from dtw_show import DTWShow2, SedShow

            tt = []
            
            tt.append(DTWShow2("result 0", ref.todtw(),infile.todtw(),res.result[0][1]))
            tt.append(SedShow("result 0",ref.todtw(),infile.todtw(),res.result[0][1]))
            
            
        
            DTWShow2.run()

        
            
        return True
        
        
    def getargs(self, argv):
        if not argv : argv = sys.argv
        from optparse import OptionParser
        op = OptionParser( 
            usage = "usage: %prog [options] InFile", 
            version = '%s v%s (%s)'%(prog_name, prog_version, prog_date), 
        )
        op.add_option('-o', '--out-file', 
            help = 'out file name (default:%s)'%self.outfile, 
            dest = 'outfile', 
        )
        op.add_option('-e', '--out-ext', 
            help = 'out file extention (default:%s)'%self.outext, 
            dest = 'outext', 
        )
        op.add_option('-r', '--ref-file', 
            help = 'reference file (default:%s)'%self.reffile, 
            dest = 'reffile', 
        )

        op.add_option('-n', '--nbr-res', type='int', 
            help = 'number of result (default:%i)'%self.nbrres, 
            dest = 'nbrres', 
        )
        op.add_option('-m', '--max-path', type='int', 
            help = 'max number of path', 
            dest = 'maxpath', 
        )
        
        op.add_option('-g', '--graph',action='store_true' , 
            help = 'show graphical result', 
            dest = 'showgraph', 
        )
        #op.add_option(())
        
        
        try : opts,  args = op.parse_args(argv)
        except :   return False
            
            
        if len(args) != 2 :
            op.error("Error: InFile missing")
            return False
        
        for k, v in opts.__dict__.iteritems() :
            if v is not None :
                assert hasattr(self, k)
                setattr(self, k, v)
        
        self.infile = args[1]
        return True
        
        
    
    
    @classmethod 
    def main(cls, argv=None, *p, **pp):
        x = cls(*p, **pp)
        
        if not x.getargs(argv) :
            return False
            
        if not x.run() :
            print "Error:", x.error()
            return False

        return True
        
        
    
        
        
if __name__ == '__main__' : 
    Run.main()
        
        
    
    
