#   This file is part of Cupydon.
#
#    Cupydon  is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Cupydon is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Cupydon.  If not, see <http://www.gnu.org/licenses/>
#
#    
#    Copyright(c):    ASGA, Gocad Consortium 2009-2013
#


from PyQt4 import QtCore, QtGui
import sys
Qt = QtCore.Qt
app = QtGui.QApplication(sys.argv)


class MyGraphView(QtGui.QGraphicsView) :
    menu =None
    on_resize = None
    def contextMenuEvent(self, event):
        if self.menu :
            self.menu.exec_(event.globalPos());
            
    def resizeEvent (self, evt ) :
      if self.on_resize : self.on_resize()
      QtGui.QGraphicsView.resizeEvent(self, evt)
      
    
def grow_rect(r,rx=.1,  ry=.05):
    r = QtCore.QRectF(r)
    aw = r.height()*ry
    r.setHeight(r.height()+aw)
    r.setY(r.y()-aw/2)
    aw = r.width()*rx
    r.setWidth(r.width()+aw)
    r.setX(r.x()-aw/2)
    
    return r

class GraphShow(QtGui.QMainWindow):
    def_size = (800, 800)
    auto_resize = True
    no_zoom = False
    auto_full_resize = False
    def __init__(self,title,  *p, **pp):
        QtGui.QMainWindow.__init__(self, None)
        self.view = None
        self.scn = None
        self.resize(*self.def_size)

        self.scn = QtGui.QGraphicsScene(self)
        
        self.best_rect = None

        self.init(*p, **pp)
        self.setWindowTitle(title)
        self.view = v = MyGraphView( self.scn, self)

        self.setCentralWidget(v)
        self.show()
        
        if self.auto_resize :
            if self.best_rect :
                self.zoom_best()
            else:
                self.zoom_full()

        if not self.no_zoom :
            m = self.view.menu = QtGui.QMenu(self.view)
            if self.best_rect :
                m.addAction("Best", self.zoom_best)
            m.addAction("Full", self.zoom_full)
            m.addAction("Zoom *2", self.zoom_2)
            m.addAction("Zoom *4", self.zoom_4)
            m.addAction("Zoom *8", self.zoom_8)
            m.addAction("Zoom *16", self.zoom_16)
            m.addAction("Zoom *32", self.zoom_32)
            m.addAction("Zoom *64", self.zoom_64)
        if self.auto_full_resize : 
            self.view.on_resize = self.zoom_full
        
    def zoom_best(self):
        self.view.fitInView(self.best_rect)
    def zoom_full(self):
        if self.view and self.scn :
            self.view.fitInView(grow_rect(self.scn.sceneRect()))
        
    def zoom_2(self): self.zoom(2.)
    def zoom_4(self): self.zoom(4.)
    def zoom_8(self): self.zoom(4.)
    def zoom_16(self): self.zoom(16.)
    def zoom_32(self): self.zoom(32.)
    def zoom_64(self): self.zoom(64.)
    def zoom(self, n):
        center = self.view.mapToScene(self.view.rect().center())
        rr = self.scn.sceneRect()
        rr.setHeight(rr.height()/n)
        self.view.fitInView(grow_rect(rr))
    
        self.view.centerOn(center)
        pass
    def test(self):
        rr = self.scn.sceneRect()
        print 'test'
        
    def init(self):
        self.scn.addRect(0, 0, 15, 15)
        pass

    @staticmethod
    def run():

        app.exec_()





class DTWShow(GraphShow):
    def_size = (200, 800)
    def init(self, dtw):
        scn =self.scn
        print "aa"
        b1 = QtGui.QBrush()
        b2 = QtGui.QBrush(Qt.black)
        ppath = dtw.spath()
        def drawp(x, cc, col):
            yy = cc[0]
            for y in cc[1:] :
                if col : b = b1
                else : b = b2
                col = not col
                scn.addRect(x, -yy, 10, -y+yy, QtGui.QPen(), b)
                yy = y


        y1 = [0]
        for x in range(dtw.n1) :
            y1.append(y1[-1] +dtw.data1(x))
        y2 = [0]
        for x in range(dtw.n2) :
            y2.append(y2[-1] +dtw.data2(x))
            
        if True :
            dx = (y2[ppath[0][1]] +y2[ppath[-1][1]]-y1[ppath[0][0]]-y1[ppath[-1][0]])/2
            print "DX", dx
            print y2
            for x in range(dtw.n2+1) :
                y2[x]-=dx
            print y2


        drawp(0, y1, dtw.col1(0))
        drawp(30, y2, dtw.col2(0))

        for a, b in ppath :
            scn.addLine(10, -y1[a], 30, -y2[b])


class DTWShow2(GraphShow):
    def_size = (200, 800)
    ter_resize = True    
    
    def init(self, ref,ter, map1, map2= None ):
        scn =self.scn
        b2 = QtGui.QBrush()
        b1 = QtGui.QBrush(Qt.black)
        
        
        if map2 : 
            w = 70.
        else : 
            w = 40.
            
        ref_start = ref[0]
        ref = ref[1:]
        #ref_ht = sum(ref)
        #ref_len = len(ref)
        
        ter_start = ter[0]
        ter = ter[1:]
        #ter_htr = sum(ter)
        #ter_len = len(ter)
        
        ref_ys = [0]
        for i in ref : ref_ys.append(ref_ys[-1]+i)
        
        
        def draw_map(x0, x1, ymap, map_):
            for n, (a, b) in enumerate(map_) :
                scn.addLine(x0, ref_ys[a],x1, ymap[n] )
                scn.addLine(x0, ref_ys[b+1],x1, ymap[n+1] )
            
        
        def draw_boxes(ys,start, x ):
            yy = ys[0]
            for y in ys[1:] :
                if start : b = b1
                else : b = b2
                start = not start
                scn.addRect(x, yy, 10, y-yy, QtGui.QPen(), b)
                yy = y
        
        def box_ys(lgr, map):
            tl = sum(lgr)
            y0 = ref_ys[map[0][0]]
            yl = ref_ys[map[-1][1]+1] -y0

            if self.ter_resize :
                mult = yl/tl
            else :
                mult = 1.
                y0 += (yl-tl)/2
                
            yy = [y0]
            for y in lgr : 
                yy.append(yy [-1]+y*mult)
            
            return yy
            
            
            
            
        
        
        draw_boxes(ref_ys, ref_start, 0.)
        ys1 = box_ys(ter, map1)
        draw_boxes(ys1, ter_start, 30.)
        draw_map(10, 30,ys1 , map1)
        if map2 :
            ys2 = box_ys(ter, map2)
            draw_boxes(ys2, ter_start, -30.)
            draw_map(0., -20.,ys2 , map2)
            
        
        
class SedShow(GraphShow):
    def_size = (400, 400)
    no_zoom = True
    auto_full_resize = True
    
    def init(self, ref,ter, map1, map2= None ):
        scn =self.scn
        
        scn.addLine(0, 0,100, 100)
        
        ref_y = [0.]
        for i in ref[1:] : ref_y.append(ref_y[-1]+i)
        ter_x= [0.]
        for i in ter[1:] : ter_x.append(ter_x[-1]+i)
        dx = 100. /(ter_x[-1] -ter_x[0])
        for i in xrange(len(ter_x)) :
            ter_x[i] *= dx
            
            
        
        
        def draw_map(m, col = "black"):
            p = QtGui.QPen(QtGui.QColor(col))
            y0 = ref_y[m[0][0]]
            dy = 100./ (ref_y[m[-1][1]+1] -y0)
            
            for i in xrange(len(m)) :
                scn.addLine(ter_x[i], (ref_y[m[i][0]]-y0)*dy
                        , ter_x[i+1], (ref_y[m[i][1]+1]-y0)*dy, p )
            
            
            
            
        if map2 : 
            draw_map(map2, "green")
            
        draw_map(map1)
