// Fragment shader

//----------------------------------------

// Size of the screen
uniform vec2 WindowSize;

// Local radius defined by the user
uniform float LocalRadius;

// Scale data
varying vec2 coeffs;
varying float radius;

// Particle attributes
varying vec4 ex_Color;
uniform float Opacity;
uniform float TrackersOpacity;

// Center of the point (pixel coordinates)
varying vec2 pos;

//----------------------------------------

void main() {
	// Compute anisotropic distance to the center of the circle \n"
	vec2 anisotropic_diff_square = (pos - gl_FragCoord.xy) * (pos - gl_FragCoord.xy) * coeffs * coeffs;
	float dist_square = anisotropic_diff_square.x + anisotropic_diff_square.y;

	// Discard pixels out of the circle
	if( dist_square > radius ) discard;

	// Assign the right opacity to the pixel
	float alpha = ( 1.0 - dist_square / radius ) * ( 1.0 - dist_square / radius );
	if ( TrackersOpacity > 0.5 ) alpha = min(Opacity*ex_Color.a,1.0)*alpha;
	else alpha = min(ex_Color.a,1.0)*Opacity*alpha;
	gl_FragColor = vec4(ex_Color.rgb,alpha);
}
