#ifndef DEFINE_H_INCLUDED
#define DEFINE_H_INCLUDED

//-----------------------------------------
//         Customizable part
//-----------------------------------------

// ---------- Particule update mode ----------
//#define CPU_MODE								// Comment/uncomment to activate CPU/GPU mode

// ----------  Particle attributes  ----------
#define PARTICLES_LIFETIME_MAX       500		// Maximum lifetime of a particle
#define PARTICLES_LIFETIME_MIN        50		// Minimum lifetime of a particle
#define PARTICLES_LOCAL_RADIUS         6		// Radius of the particles
#define PARTICLES_COLOR_R            0.2		// Particle color (red)
#define PARTICLES_COLOR_G            0.2		// Particle color (green)
#define PARTICLES_COLOR_B            0.2		// Particle color (blue)
#define PARTICLES_COLOR_A            1.0		// Particle color (alpha)

// ----------   Colored trackers    ----------
#define TRACKER_COUNT                  5		// Number of colored trackers

// ----------      Window data      ----------
#define WINDOW_HEIGHT                512		// Initial height of the window
#define WINDOW_WIDTH                 512		// Initial width of the window
#define BACKGROUND_COLOR_R           1.0		// Particle color (red)
#define BACKGROUND_COLOR_G           1.0		// Particle color (green)
#define BACKGROUND_COLOR_B           1.0		// Particle color (blue)

// ----------     Framerate data    ----------
#define FPS_TIME                       1		// Minimum number of seconds between FPS updates
#define FPS_MIN_FRAMES                10		// Minimum number of frames between FPS updates



//-----------------------------------------
//        Non-customizable part
//-----------------------------------------

#include <GL/glew.h>
#include <gl/gl.h>

#include <iostream>
#include <fstream>

//#define BENCHMARKS

#ifdef BENCHMARKS
	#define WINDOW_MODE GLUT_SINGLE
#else
	#define WINDOW_MODE GLUT_DOUBLE
#endif

#define nil 0			// Null pointers

#define P_SIZE 3		// Size of coordinates
#define C_SIZE 4		// Size of colors
#define A_SIZE 3		// Size of particle's attributes (particle lifetime, x_deformation factor and y_deformation_factor)

#endif // DEFINE_H_INCLUDED

