#ifndef UncertaintyViewer_gtools_OpenGL_h
#define UncertaintyViewer_gtools_OpenGL_h

#include <GL/glew.h>

#include <string>


//! Small util class used to convert an OpenGL error code into its corresponding string
class OpenGLError {

public:
	//! Convert an OpenGL error code into its corresponding string
	/*!
	 @param error The OpenGL error code
	 @return The CString which corresponds to the error code, if any
	 @note Valid error codes are GL_NO_ERROR, GL_INVALID_ENUM, GL_INVALID_VALUE,
	       GL_INVALID_OPERATION, GL_STACK_OVERFLOW, GL_STACK_UNDERFLOW,
		   GL_OUT_OF_MEMORY and GL_TABLE_TOO_LARGE
	 */
	static std::string gl_error(GLenum error) {
		if ( error == GL_NO_ERROR )				return "GL_NO_ERROR";
		if ( error == GL_INVALID_ENUM )			return "GL_INVALID_ENUM";
		if ( error == GL_INVALID_VALUE )		return "GL_INVALID_VALUE";
		if ( error == GL_INVALID_OPERATION )	return "GL_INVALID_OPERATION";
		if ( error == GL_STACK_OVERFLOW )		return "GL_STACK_OVERFLOW";
		if ( error == GL_STACK_UNDERFLOW )		return "GL_STACK_UNDERFLOW";
		if ( error == GL_OUT_OF_MEMORY )		return "GL_OUT_OF_MEMORY";
		if ( error == GL_TABLE_TOO_LARGE )		return "GL_TABLE_TOO_LARGE";
		return "UNKNOWN ERROR";
	}
};

//! Check whether an OpenGL error occurred so far, and display the result only if there was an error
/*!
 @note For the sake of efficiency, this only works in debug mode
 */
#ifndef _DEBUG
	#define CHECK_GL_ERRORS {}
#else
	#define CHECK_GL_ERRORS { \
		GLenum err = glGetError(); \
		if ( err ) \
			std::cout << "Error " << OpenGLError::gl_error(err).c_str() << " at line " << __LINE__ << " in file " << __FILE__  << std::endl; \
	}
#endif

//! Check whether an OpenGL error occurred so far, and display the result whether there was an error or not
/*!
 @note For the sake of efficiency, this only works in debug mode
 */
#ifndef _DEBUG
	#define CHECK_GL_ERRORS_INFO {}
#else
	#define CHECK_GL_ERRORS_INFO { \
		GLenum err = glGetError(); \
		if ( err ) \
			std::cout << "Error " << OpenGLError::gl_error(err).c_str() << " at line " << __LINE__ << " in file " << __FILE__  << std::endl; \
		else \
			std::cout << "No error at line " << __LINE__ << " in file " << __FILE__  << std::endl; \
	}
#endif

#endif

