#ifndef utils_gslib_h
#define utils_gslib_h

//! Loader for GSlib files
class GSlib {

public:
	template <class T> static T* load_file(int& nb_props, int& size_u, int& size_v,
											std::list<std::string>& property_names,
											const char* filename);
	template <class T> static T* load_file(int& nb_props, int& size_u, int& size_v, int& size_w,
											std::list<std::string>& property_names,
											const char* filename);
	template <class T> static T* load_raw_file( int& size, const char* filename);

private:
	static void string_split(std::list<std::string>& result, const std::string& str);
	template <class T> static T string_convert(const std::string& str);
};

#include <GSlib.hpp>

#endif
