#ifndef UTILS_H_INCLUDED
#define UTILS_H_INCLUDED

#include <cmath>
#include <Define.h>


/*!
*  \brief Chooses a random float value.
*
*	This function chooses a random float value between min and max.
*
*	\param min : this argument is the minimum float value.
*	\param max : this argument is the maximum float value.
*/
float my_float_rand(float min, float max);

/*!
*  \brief Chooses a random integer value.
*
*	This function chooses a random integer value between min and max.
*
*	\param min : this argument is the minimum integer value.
*	\param max : this argument is the maximum integer value.
*/
int my_int_rand(float min, float max);

/*!
*  \brief Draws axis in the window.
*
*	This function draws axis in the window.
*	Red axis <--> X axis
*	Green axis <--> Y axis
*	Blue axis <--> Z axis
*
*	\param width : this argument is the axis width.
*	\param width : this argument is the axis lenght.
*/
void drawAxis(float width, float scale);

/*!
*  \brief Draws the cube in the window.
*
*	This function draws the cube in the window.
*
*	\param width : this argument is the line width.
*/
void drawCube(float width, float scale);

void drawCube(float width, float x, float y, float z, float xscale, float yscale, float zscale, float r, float g, float b);

#endif // UTILS_H_INCLUDED
