#ifndef PARTICLE_H_INCLUDED
#define PARTICLE_H_INCLUDED

#include <Define.h>



/*! \class Particle
 *
 *  \brief Class used to describe parameters of one single particle.
 *
 *  Those parameters include the particle's position, color, age, maximum lifetime,
 *	velocity and radius.
 */

class Particle {
public:

    // Methods

	 /*!
     *  \brief Constructor of one particle.
     *
     *  Constructor of the particle class.
     */
    Particle(); 

	 /*!
     *  \brief Destructor of one particle
     *
     *  Destructor of the particle class.
     */
    ~Particle();

	/*!
     *  \brief Draws one particle
     *
     *  This method allows the drawing of one particle, this implies the computing of transparency.
     *
     *  \param shader : Shader code executed one the GPU (Here zoom factor and radius transparency).
     */
    //void draw(const GLSLShader& shader/*, GLuint vbo*/);

	/*!
     *  \brief Initializes one particle
     *
     *  This method initializes the parameters of the particle.
	 * This method is called after it has been detected that a particle has crossed the limits of the domain or its gae is greater than its maximum lifetime.
     */
    void init();

    // Position accessors
    inline float get_x() const				{ return x_;}
    inline float get_y() const				{ return y_;}
    inline float get_z() const				{ return z_;}
    inline void  set_x(const float new_x)	{ x_=new_x; }
    inline void  set_y(const float new_y)	{ y_=new_y; }
    inline void  set_z(const float new_z)	{ z_=new_z; }

    // Color accessors
    inline float get_r() const				{ return r_;}
    inline float get_g() const				{ return g_;}
    inline float get_b() const				{ return b_;}
	inline float get_transparency() const	{ return transparency_;}
    inline void  set_r(const float new_r)	{ r_=new_r; }
    inline void  set_g(const float new_g)	{ g_=new_g; }
    inline void  set_b(const float new_b)	{ b_=new_b; }
    inline void  set_transparency(const float new_transparency) { transparency_=new_transparency; }
    inline void  set_color(const float r, const float g, const float b) {r_=r; g_=g; b_=b ;}

    // Age accessors
    inline float get_age () const		{ return age_; }
	inline int   get_lifetime () const	{ return lifetime_; }
    inline void set_age (const float new_age ) { age_ = new_age; }
    inline void set_lifetime (const int new_lifetime ) { lifetime_ = new_lifetime; }

private:
	//! Particle maximum lifetime, randomly chosen between min_lifetime_ and max_lifetime.
    int lifetime_ ;
	//! Particle age, this attribute is incremented at each step
    float age_ ; 
	//! Particle transparency, pay attention, this attribute is different from the radial transparency computed on the quads.
    float transparency_ ; 
	//! Red, green and blue values of the particle.
    float r_, g_, b_ ; 
	//! Position of the particle in object coordinates.
    float x_, y_, z_ ; 
};

#endif // PARTICLE_H_INCLUDED
