#ifndef PARTICLEENGINE_H_INCLUDED
#define PARTICLEENGINE_H_INCLUDED

#include <Define.h>
#include <Particle.h>
#include <Shader.h>


/*! \class ParticleEngine
 *  
 *  \brief Class used to manage the entire set of particles screened.
 *
 *  This management includes drawing, initialisation, icrementation of position, tests on the age, the position of the particles and computation of the particles' color.
 */

class ParticleEngine{
public:

    /* Methods */

	 /*!
     *  \brief Default constructor of a set of particles
     *
     *  \note This default constructor creates only 100 particles.
     *
     */
    ParticleEngine(); // Default constructor, by default 100 particles

	 /*!
     *  \brief Constructor of a set of particles
     *
     *  \note This constructor creates a set of particles which number is given as an argument of this function.
	 *	\param max_particles is the integer that corresponds to the number of particles.
     */
    ParticleEngine(int max_particles);

	/*!
     *  \brief Destructor of the ParticleEngine
     *
     *  Destructor of the ParticleEngine class.
     */
    ~ParticleEngine(); // Destructor

	/*!
     *  \brief Draws the set of particles
     *
     *  This method allows the drawing of the set of particles, this method iterates on the array of particles.
     *
     */
    void draw_particles() const; // Draw all particles

	void sort_particles();

    bool update_particles(float* data_vector,
				int nb_props, int sizeu, int sizev, int sizew,
				int velocity, bool pause,
				float* points, float* ranges, float* colors); // Update all particles

#ifndef CPU_MODE
	void read_vbos();
	void fill_vbos(bool generate = true);

    // Accessors 
	GLuint get_vbo_location() const;
	GLuint get_vbo_color() const;
	GLuint get_vbo_attributes() const;
#endif

    inline float get_engine_local_radius () const { return  local_radius_ ;}
    inline void set_engine_local_radius (const float local_radius) {
        local_radius_ = local_radius ;
    }

    inline float get_engine_opacity () const { return opacity_ ;}
    inline void set_engine_opacity (const float opacity) {
        opacity_ = opacity ;
    }

    inline bool get_engine_trackers_opacity () const { return trackers_opacity_ ;}
    inline void set_engine_trackers_opacity (bool trackers_opacity) {
        trackers_opacity_ = trackers_opacity ;
    }

	inline void set_engine_width_and_height (const int new_width, const int new_height ) { 
		width_ = new_width;
		height_ = new_height;
	}

    inline int get_particle_count () const { return max_particles_ ;}

#ifndef CPU_MODE
	inline int size() { return vertex_vbo_size_; }
#endif

private:
	//! Number of particles
    int max_particles_;
	//! Pointer array on each particle of the set of particles of the ParticleEngine considered.
    Particle* particle_array_;

	//! Particles radius
    float local_radius_;
	//! Particles opacity
	float opacity_;
	//! Trackers opacity
	bool trackers_opacity_;

	//! Shader program
    GLSLShader shader_;
	//! Window size
	int width_, height_;

#ifndef CPU_MODE
	//! VBO IDs
	GLuint vbo_[3];
	//! VBO size
	int vertex_vbo_size_;
#endif
};

class ParticleSorter {

public:
	ParticleSorter();
	~ParticleSorter();

	bool operator() (const Particle& rhs, const Particle& lhs) const;

private:
	float z_particle(const Particle& particle) const;

private:
	float matrix_[4][4];
};

#endif // PARTICLEENGINE_H_INCLUDED
